/*! *********************************************************************************
* \addtogroup FSCI_BLE
* @{
********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2017 NXP
* All rights reserved.
*
* \file
*
* This is a source file for FSCI BLE management.
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/

#include "fsci_ble_gatt_db_app_types.h"


#if gFsciIncluded_c && gFsciBleGattDbAppLayerEnabled_d

/************************************************************************************
*************************************************************************************
* Private constants & macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private functions prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

void fsciBleGattDbAppGetCharPresFormatFromBuffer(gattDbCharPresFormat_t* pCharPresFormat, uint8_t** ppBuffer)
{
    fsciBleGetUint8ValueFromBuffer(pCharPresFormat->format, *ppBuffer);
    fsciBleGetUint8ValueFromBufferSigned(pCharPresFormat->exponent, *ppBuffer);
    fsciBleGetUint16ValueFromBuffer(pCharPresFormat->unitUuid16, *ppBuffer);
    fsciBleGetUint8ValueFromBuffer(pCharPresFormat->ns, *ppBuffer);
    fsciBleGetUint16ValueFromBuffer(pCharPresFormat->description, *ppBuffer);
}


void fsciBleGattDbAppGetBufferFromCharPresFormat(gattDbCharPresFormat_t* pCharPresFormat, uint8_t** ppBuffer)
{
    fsciBleGetBufferFromUint8Value(pCharPresFormat->format, *ppBuffer);
    fsciBleGetBufferFromUint8Value((uint8_t)pCharPresFormat->exponent, *ppBuffer);
    fsciBleGetBufferFromUint16Value(pCharPresFormat->unitUuid16, *ppBuffer);
    fsciBleGetBufferFromUint8Value(pCharPresFormat->ns, *ppBuffer);
    fsciBleGetBufferFromUint16Value(pCharPresFormat->description, *ppBuffer);  
}

/************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/

#endif /* gFsciIncluded_c && gFsciBleGattDbAppLayerEnabled_d */

/*! *********************************************************************************
* @}
********************************************************************************** */
